import os
import random
import json
from captcha.image import ImageCaptcha

NUM_OF_CAPTCHA = 100
MIN_LEN = 4
MAX_LEN = 6
FOLDER = 'images'
EXT = '.png'

def charlist():
    """Generate a string with all caracters upper, lower and digits"""
    chars = ""
    for i in range(26):
        chars += chr(ord('a')+i)
    chars += chars.upper()
    for i in range(10):
        chars += chr(ord('0')+i)
    return chars

def charlist2():
    """Generate a string with some upper chars and some digits easy to read"""
    chars = ""
    chars += "ERTYUIPASDFGHJKLZXCVB"
    chars += '2345689'
    return chars

def random_name(chars, min_len=MIN_LEN, max_len=MAX_LEN):
    """Generate a random string """
    name_len = random.randint(min_len, max_len)
    result = ""
    for i in range(name_len):
        pos = random.randint(0, len(chars)-1)
        result += chars[pos]
    return result

def captcha_image(name, text, extension=EXT, folder=FOLDER):
    # select a font not to hard to read by humans. i.e.:
    # https://www.free-fonts.com/courier
    image = ImageCaptcha(fonts=['cour.ttf'], width = 260, height = 70)
    data = image.generate(text)
    image.write(text, os.path.join(folder,name+extension))

if __name__ == "__main__":
    chars = charlist2()
    captcha = {}
    for i in range(NUM_OF_CAPTCHA):
        captcha["%05d" %i] = random_name(chars)

    for k,v in captcha.items():
        print(k, v)
        captcha_image(k, v)

    with open(os.path.join(FOLDER,"index.json"), 'w') as fp:
        json.dump(captcha, fp, indent=2)


